#!/bin/bash
chmod +x Tools/gigaflash_x64
chmod +x Tools/gigaflash
chmod +x Tools/gigaflash_arm
#assign fw path
fw_path=fw/130618.bin

check_number='^[0-9]+$'

#check all parameter
for (( index=1; index<=$#; index++)); do
    if [ ${!index} = "cs" ]; then
        next=$((index+1))
        cs="-cs ${!next}"
		#Check flash address parameter
        if ! [[ ${!next} =~ $check_number ]]; then
            echo "Please check flash address parameter"
            exit 1
        fi
    elif [ ${!index} = "x32" ]; then
        os_version="32"
    elif [ ${!index} = "arm" ]; then
        os_version="arm"
    elif [ ${!index} = "flashall" ]; then
        flashall_flag="-a"
    elif [[ ${!index} = "preserve" ]]; then
        flashall_flag="-preserve"
    fi
done

#if flash address not assign; default set address 0
if ! [[ -n "$cs" ]]; then
    cs="-cs 0"
fi

if [[ $os_version = "32" ]]; then
    Tools/gigaflash $fw_path $cs $flashall_flag -2600
elif [[ $os_version = "arm" ]]; then
    Tools/gigaflash_arm $fw_path $cs $flashall_flag -2600
else
    Tools/gigaflash_x64 $fw_path $cs $flashall_flag -2600
fi
