#ifndef __PLX_CHIP_API_H
#define __PLX_CHIP_API_H

/*******************************************************************************
 * Copyright 2013-2015 Avago Technologies
 * Copyright (c) 2009 to 2012 PLX Technology Inc.  All rights reserved.
 *
 * This software is available to you under a choice of one of two
 * licenses.  You may choose to be licensed under the terms of the GNU
 * General Public License (GPL) Version 2, available from the file
 * COPYING in the main directorY of this source tree, or the
 * BSD license below:
 *
 *     Redistribution and use in source and binary forms, with or
 *     without modification, are permitted provided that the following
 *     conditions are met:
 *
 *      - Redistributions of source code must retain the above
 *        copyright notice, this list of conditions and the following
 *        disclaimer.
 *
 *      - Redistributions in binary form must reproduce the above
 *        copyright notice, this list of conditions and the following
 *        disclaimer in the documentation and/or other materials
 *        provided with the distribution.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
 * BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
 * ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 ******************************************************************************/

/******************************************************************************
 *
 * File Name:
 *
 *      PlxChipApi.h
 *
 * Description:
 *
 *      Header for PLX chip-specific API functions
 *
 * Revision History:
 *
 *      12-01-16 : PLX SDK v7.25
 *
 ******************************************************************************/

#include "DrvDefs.h"

/**********************************************
 *                Functions
 *********************************************/
PLX_STATUS
PlxChip_BoardReset(DEVICE_EXTENSION* pdx);

U32 PlxChip_MailboxRead(DEVICE_EXTENSION* pdx, U16 mailbox,
                        PLX_STATUS* pStatus);

PLX_STATUS
PlxChip_MailboxWrite(DEVICE_EXTENSION* pdx, U16 mailbox, U32 value);

PLX_STATUS
PlxChip_EepromReadByOffset(DEVICE_EXTENSION* pdx, U32 offset, U32* pValue);

PLX_STATUS
PlxChip_EepromWriteByOffset(DEVICE_EXTENSION* pdx, U32 offset, U32 value);

PLX_STATUS
PlxChip_InterruptEnable(DEVICE_EXTENSION* pdx, PLX_INTERRUPT* pPlxIntr);

PLX_STATUS
PlxChip_InterruptDisable(DEVICE_EXTENSION* pdx, PLX_INTERRUPT* pPlxIntr);

PLX_STATUS
PlxChip_DmaChannelOpen(DEVICE_EXTENSION* pdx, U8 channel, VOID* pOwner);

PLX_STATUS
PlxChip_DmaGetProperties(DEVICE_EXTENSION* pdx, U8 channel,
                         PLX_DMA_PROP* pProp);

PLX_STATUS
PlxChip_DmaSetProperties(DEVICE_EXTENSION* pdx, U8 channel, PLX_DMA_PROP* pProp,
                         VOID* pOwner);

PLX_STATUS
PlxChip_DmaControl(DEVICE_EXTENSION* pdx, U8 channel, PLX_DMA_COMMAND command,
                   VOID* pOwner);

PLX_STATUS
PlxChip_DmaStatus(DEVICE_EXTENSION* pdx, U8 channel, VOID* pOwner);

PLX_STATUS
PlxChip_DmaTransferBlock(DEVICE_EXTENSION* pdx, U8 channel,
                         PLX_DMA_PARAMS* pParams, VOID* pOwner);

PLX_STATUS
PlxChip_DmaTransferUserBuffer(DEVICE_EXTENSION* pdx, U8 channel,
                              PLX_DMA_PARAMS* pParams, VOID* pOwner);

PLX_STATUS
PlxChip_DmaChannelClose(DEVICE_EXTENSION* pdx, U8 channel,
                        BOOLEAN bCheckInProgress, VOID* pOwner);

#endif
