#ifndef __API_FUNCTIONS_H
#define __API_FUNCTIONS_H

/*******************************************************************************
 * Copyright 2013-2015 Avago Technologies
 * Copyright (c) 2009 to 2012 PLX Technology Inc.  All rights reserved.
 *
 * This software is available to you under a choice of one of two
 * licenses.  You may choose to be licensed under the terms of the GNU
 * General Public License (GPL) Version 2, available from the file
 * COPYING in the main directorY of this source tree, or the
 * BSD license below:
 *
 *     Redistribution and use in source and binary forms, with or
 *     without modification, are permitted provided that the following
 *     conditions are met:
 *
 *      - Redistributions of source code must retain the above
 *        copyright notice, this list of conditions and the following
 *        disclaimer.
 *
 *      - Redistributions in binary form must reproduce the above
 *        copyright notice, this list of conditions and the following
 *        disclaimer in the documentation and/or other materials
 *        provided with the distribution.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
 * BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
 * ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 ******************************************************************************/

/******************************************************************************
 *
 * File Name:
 *
 *      ApiFunc.h
 *
 * Description:
 *
 *      The header file for the PLX API functions
 *
 * Revision History:
 *
 *      02-01-13 : PLX SDK v7.00
 *
 ******************************************************************************/

#include "DrvDefs.h"

/**********************************************
 *                Functions
 *********************************************/
PLX_STATUS
PlxDeviceFind(DEVICE_EXTENSION* pdx, PLX_DEVICE_KEY* pKey, U16* pDeviceNumber);

PLX_STATUS
PlxChipTypeGet(DEVICE_EXTENSION* pdx, U16* pChipType, U8* pRevision);

PLX_STATUS
PlxChipTypeSet(DEVICE_EXTENSION* pdx, U16 ChipType, U8 Revision);

PLX_STATUS
PlxGetPortProperties(DEVICE_EXTENSION* pdx, PLX_PORT_PROP* pPortProp);

PLX_STATUS
PlxPciDeviceReset(DEVICE_EXTENSION* pdx);

U32 PlxRegisterRead(DEVICE_EXTENSION* pdx, U32 offset, PLX_STATUS* pStatus,
                    BOOLEAN bAdjustForPort);

PLX_STATUS
PlxRegisterWrite(DEVICE_EXTENSION* pdx, U32 offset, U32 value,
                 BOOLEAN bAdjustForPort);

PLX_STATUS
PlxPciBarProperties(DEVICE_EXTENSION* pdx, U8 BarIndex,
                    PLX_PCI_BAR_PROP* pBarProperties);

PLX_STATUS
PlxPciBarMap(DEVICE_EXTENSION* pdx, U8 BarIndex, VOID* pUserVa, VOID* pOwner);

PLX_STATUS
PlxPciBarUnmap(DEVICE_EXTENSION* pdx, VOID* UserVa, VOID* pOwner);

PLX_STATUS
PlxEepromPresent(DEVICE_EXTENSION* pdx, U8* pStatus);

PLX_STATUS
PlxEepromProbe(DEVICE_EXTENSION* pdx, U8* pFlag);

PLX_STATUS
PlxEepromCrcGet(DEVICE_EXTENSION* pdx, U32* pCrc, U8* pCrcStatus);

PLX_STATUS
PlxEepromCrcUpdate(DEVICE_EXTENSION* pdx, U32* pCrc, BOOLEAN bUpdateEeprom);

PLX_STATUS
PlxEepromReadByOffset(DEVICE_EXTENSION* pdx, U32 offset, U32* pValue);

PLX_STATUS
PlxEepromWriteByOffset(DEVICE_EXTENSION* pdx, U32 offset, U32 value);

PLX_STATUS
PlxEepromReadByOffset_16(DEVICE_EXTENSION* pdx, U32 offset, U16* pValue);

PLX_STATUS
PlxEepromWriteByOffset_16(DEVICE_EXTENSION* pdx, U32 offset, U16 value);

PLX_STATUS
PlxPciIoPortTransfer(U64 IoPort, VOID* pBuffer, U32 SizeInBytes,
                     PLX_ACCESS_TYPE AccessType, BOOLEAN bReadOperation);

PLX_STATUS
PlxPciPhysicalMemoryAllocate(DEVICE_EXTENSION* pdx, PLX_PHYSICAL_MEM* pPciMem,
                             BOOLEAN bSmallerOk, VOID* pOwner);

PLX_STATUS
PlxPciPhysicalMemoryFree(DEVICE_EXTENSION* pdx, PLX_PHYSICAL_MEM* pPciMem);

PLX_STATUS
PlxPciPhysicalMemoryMap(DEVICE_EXTENSION* pdx, PLX_PHYSICAL_MEM* pPciMem,
                        VOID* pOwner);

PLX_STATUS
PlxPciPhysicalMemoryUnmap(DEVICE_EXTENSION* pdx, PLX_PHYSICAL_MEM* pPciMem,
                          VOID* pOwner);

PLX_STATUS
PlxInterruptEnable(DEVICE_EXTENSION* pdx, PLX_INTERRUPT* pPlxIntr);

PLX_STATUS
PlxInterruptDisable(DEVICE_EXTENSION* pdx, PLX_INTERRUPT* pPlxIntr);

PLX_STATUS
PlxNotificationRegisterFor(DEVICE_EXTENSION* pdx, PLX_INTERRUPT* pPlxIntr,
                           VOID** pUserWaitObject, VOID* pOwner);

PLX_STATUS
PlxNotificationWait(DEVICE_EXTENSION* pdx, VOID* pUserWaitObject,
                    PLX_UINT_PTR Timeout_ms);

PLX_STATUS
PlxNotificationStatus(DEVICE_EXTENSION* pdx, VOID* pUserWaitObject,
                      PLX_INTERRUPT* pPlxIntr);

PLX_STATUS
PlxNotificationCancel(DEVICE_EXTENSION* pdx, VOID* pUserWaitObject,
                      VOID* pOwner);

PLX_STATUS
PlxPciBarSpaceTransfer(DEVICE_EXTENSION* pdx, U8 BarIndex, U32 offset,
                       U8* pBuffer, U32 ByteCount, PLX_ACCESS_TYPE AccessType,
                       BOOLEAN bRemap, BOOLEAN bReadOperation);

PLX_STATUS
PlxPciVpdRead(DEVICE_EXTENSION* pdx, U16 offset, U32* pValue);

PLX_STATUS
PlxPciVpdWrite(DEVICE_EXTENSION* pdx, U16 offset, U32 VpdData);

#endif
