/* SPDX-License-Identifier: BSD-3-Clause
 * Copyright(c) 2019-2021 Broadcom
 *  All rights reserved.
 */
#ifndef _CFA_P58_HW_H_
#define _CFA_P58_HW_H_

/* Definitions of the base FKB fields */
#define CFA_P58_BASE_FKB_L2_CTXT_FLD (0)
#define CFA_P58_BASE_FKB_PARIF_FLD (1)
#define CFA_P58_BASE_FKB_SPIF_FLD (2)
#define CFA_P58_BASE_FKB_SVIF_FLD (3)
#define CFA_P58_BASE_FKB_LCOS_FLD (4)
#define CFA_P58_BASE_FKB_META_FLD (5)
#define CFA_P58_BASE_FKB_RCYC_CNT_FLD (6)
#define CFA_P58_BASE_FKB_LOOPBACK_FLD (7)

#define CFA_P58_BASE_FKB_OT_L2_TYPE_FLD (8)
#define CFA_P58_BASE_FKB_OT_DMAC_FLD (9)
#define CFA_P58_BASE_FKB_OT_SMAC_FLD (10)
#define CFA_P58_BASE_FKB_OT_DEST_TYPE_FLD (11)
#define CFA_P58_BASE_FKB_OT_SA_FLD (12)
#define CFA_P58_BASE_FKB_OT_NVT_FLD (13)
#define CFA_P58_BASE_FKB_OT_OVP_FLD (14)
#define CFA_P58_BASE_FKB_OT_OVD_FLD (15)
#define CFA_P58_BASE_FKB_OT_OVV_FLD (16)
#define CFA_P58_BASE_FKB_OT_OVT_FLD (17)
#define CFA_P58_BASE_FKB_OT_IVP_FLD (18)
#define CFA_P58_BASE_FKB_OT_IVD_FLD (19)
#define CFA_P58_BASE_FKB_OT_IVV_FLD (20)
#define CFA_P58_BASE_FKB_OT_IVT_FLD (21)
#define CFA_P58_BASE_FKB_OT_ETYPE_FLD (22)

#define CFA_P58_BASE_FKB_OT_L3_TYPE_FLD (23)
#define CFA_P58_BASE_FKB_OT_SIP_FLD (24)
#define CFA_P58_BASE_FKB_OT_SIP_SELCMP_FLD (25)
#define CFA_P58_BASE_FKB_OT_DIP_FLD (26)
#define CFA_P58_BASE_FKB_OT_DIP_SELCMP_FLD (27)
#define CFA_P58_BASE_FKB_OT_TTL_FLD (28)
#define CFA_P58_BASE_FKB_OT_L3_PROT_FLD (29)
#define CFA_P58_BASE_FKB_OT_FLOW_ID_FLD (30)
#define CFA_P58_BASE_FKB_OT_QOS_FLD (31)
#define CFA_P58_BASE_FKB_OT_IEH_NO_NEXT_FLD (32)
#define CFA_P58_BASE_FKB_OT_IEH_ESP_FLD (33)
#define CFA_P58_BASE_FKB_OT_IEH_AUTH_FLD (34)
#define CFA_P58_BASE_FKB_OT_IEH_DEST_FLD (35)
#define CFA_P58_BASE_FKB_OT_IEH_FRAG_FLD (36)
#define CFA_P58_BASE_FKB_OT_IEH_RTHDR_FLD (37)
#define CFA_P58_BASE_FKB_OT_IEH_HOP_FLD (38)
#define CFA_P58_BASE_FKB_OT_IEH_1FRAG_FLD (39)
#define CFA_P58_BASE_FKB_OT_IEH_DF_FLD (40)
#define CFA_P58_BASE_FKB_OT_L3_ERRORS_FLD (41)

#define CFA_P58_BASE_FKB_OT_L4_TYPE_FLD (42)
#define CFA_P58_BASE_FKB_OT_SRC_PORT_FLD (43)
#define CFA_P58_BASE_FKB_OT_DEST_PORT_FLD (44)
#define CFA_P58_BASE_FKB_OT_L4_FLAGS_FLD (45)
#define CFA_P58_BASE_FKB_OT_L4_SEQ_FLD (46)
#define CFA_P58_BASE_FKB_OT_L4_PA_FLD (47)
#define CFA_P58_BASE_FKB_OT_L4_OPT_FLD (48)
#define CFA_P58_BASE_FKB_OT_L4_TCPTS_FLD (49)
#define CFA_P58_BASE_FKB_OT_L4_ERRORS_FLD (50)

#define CFA_P58_BASE_FKB_OT_T_TYPE_FLD (51)
#define CFA_P58_BASE_FKB_OT_T_FLAGS_FLD (52)
#define CFA_P58_BASE_FKB_OT_TIDS_FLD (53)
#define CFA_P58_BASE_FKB_OT_TID_FLD (54)
#define CFA_P58_BASE_FKB_OT_TCTXTS_FLD (55)
#define CFA_P58_BASE_FKB_OT_TCTXT_FLD (56)
#define CFA_P58_BASE_FKB_OT_TQOS_FLD (57)
#define CFA_P58_BASE_FKB_OT_TERRORS_FLD (58)

#define CFA_P58_BASE_FKB_T_L2_TYPE_FLD (59)
#define CFA_P58_BASE_FKB_T_DMAC_FLD (60)
#define CFA_P58_BASE_FKB_T_SMAC_FLD (61)
#define CFA_P58_BASE_FKB_T_DEST_TYPE_FLD (62)
#define CFA_P58_BASE_FKB_T_SA_FLD (63)
#define CFA_P58_BASE_FKB_T_NVT_FLD (64)
#define CFA_P58_BASE_FKB_T_OVP_FLD (65)
#define CFA_P58_BASE_FKB_T_OVD_FLD (66)
#define CFA_P58_BASE_FKB_T_OVV_FLD (67)
#define CFA_P58_BASE_FKB_T_OVT_FLD (68)
#define CFA_P58_BASE_FKB_T_IVP_FLD (69)
#define CFA_P58_BASE_FKB_T_IVD_FLD (70)
#define CFA_P58_BASE_FKB_T_IVV_FLD (71)
#define CFA_P58_BASE_FKB_T_IVT_FLD (72)
#define CFA_P58_BASE_FKB_T_ETYPE_FLD (73)

#define CFA_P58_BASE_FKB_T_L3_TYPE_FLD (74)
#define CFA_P58_BASE_FKB_T_SIP_FLD (75)
#define CFA_P58_BASE_FKB_T_SIP_SELCMP_FLD (76)
#define CFA_P58_BASE_FKB_T_DIP_FLD (77)
#define CFA_P58_BASE_FKB_T_DIP_SELCMP_FLD (78)
#define CFA_P58_BASE_FKB_T_TTL_FLD (79)
#define CFA_P58_BASE_FKB_T_L3_PROT_FLD (80)
#define CFA_P58_BASE_FKB_T_FLOW_ID_FLD (81)
#define CFA_P58_BASE_FKB_T_QOS_FLD (82)
#define CFA_P58_BASE_FKB_T_IEH_NO_NEXT_FLD (83)
#define CFA_P58_BASE_FKB_T_IEH_ESP_FLD (84)
#define CFA_P58_BASE_FKB_T_IEH_AUTH_FLD (85)
#define CFA_P58_BASE_FKB_T_IEH_DEST_FLD (86)
#define CFA_P58_BASE_FKB_T_IEH_FRAG_FLD (87)
#define CFA_P58_BASE_FKB_T_IEH_RTHDR_FLD (88)
#define CFA_P58_BASE_FKB_T_IEH_HOP_FLD (89)
#define CFA_P58_BASE_FKB_T_IEH_1FRAG_FLD (90)
#define CFA_P58_BASE_FKB_T_IEH_DF_FLD (102)
#define CFA_P58_BASE_FKB_T_L3_ERRORS_FLD (92)

#define CFA_P58_BASE_FKB_T_L4_TYPE_FLD (93)
#define CFA_P58_BASE_FKB_T_SRC_PORT_FLD (94)
#define CFA_P58_BASE_FKB_T_DEST_PORT_FLD (95)
#define CFA_P58_BASE_FKB_T_L4_FLAGS_FLD (96)
#define CFA_P58_BASE_FKB_T_L4_SEQ_FLD (97)
#define CFA_P58_BASE_FKB_T_L4_ACK_FLD (98)
#define CFA_P58_BASE_FKB_T_L4_WIN_FLD (99)
#define CFA_P58_BASE_FKB_T_L4_PA_FLD (100)
#define CFA_P58_BASE_FKB_T_L4_OPT_FLD (101)
#define CFA_P58_BASE_FKB_T_L4_TCPTS_FLD (102)
#define CFA_P58_BASE_FKB_T_L4_TSVAL_FLD (103)
#define CFA_P58_BASE_FKB_T_L4_TXECR_FLD (104)
#define CFA_P58_BASE_FKB_T_L4_ERRORS_FLD (105)

#define CFA_P58_BASE_FKB_MAX_FLD (CFA_P58_BASE_FKB_T_L4_ERRORS_FLD + 1)

#define CFA_P58_EM_FKB_MAX_FLD CFA_P58_BASE_FKB_MAX_FLD
#define CFA_P58_WC_TCAM_FKB_MAX_FLD CFA_P58_BASE_FKB_MAX_FLD

/* TCAM entry is valid (for idx 6 ...) */
#define CFA_P58_PROF_L2_CTXT_TCAM_VALID_BITPOS 212
#define CFA_P58_PROF_L2_CTXT_TCAM_VALID_NUM_BITS 1

/* Multi-pass cycle count. (for idx 6 ...) */
#define CFA_P58_PROF_L2_CTXT_TCAM_MPASS_CNT_BITPOS 210
#define CFA_P58_PROF_L2_CTXT_TCAM_MPASS_CNT_NUM_BITS 2

/* Recycle count from prof_in (for idx 6 ...) */
#define CFA_P58_PROF_L2_CTXT_TCAM_RCYC_BITPOS 208
#define CFA_P58_PROF_L2_CTXT_TCAM_RCYC_NUM_BITS 2

/* loopback input from prof_in (for idx 6 ...) */
#define CFA_P58_PROF_L2_CTXT_TCAM_LOOPBACK_BITPOS 207
#define CFA_P58_PROF_L2_CTXT_TCAM_LOOPBACK_NUM_BITS 1

/* Source network port from prof_in (for idx 6 ...) */
#define CFA_P58_PROF_L2_CTXT_TCAM_SPIF_BITPOS 205
#define CFA_P58_PROF_L2_CTXT_TCAM_SPIF_NUM_BITS 2

/* Partition provided by input block (for idx 6 ...) */
#define CFA_P58_PROF_L2_CTXT_TCAM_PARIF_BITPOS 201
#define CFA_P58_PROF_L2_CTXT_TCAM_PARIF_NUM_BITS 4

/* Source network port or vnic */
#define CFA_P58_PROF_L2_CTXT_TCAM_SVIF_BITPOS 190
#define CFA_P58_PROF_L2_CTXT_TCAM_SVIF_NUM_BITS 11

/* Metadata provided by Input block (for idx 5 ...) */
#define CFA_P58_PROF_L2_CTXT_TCAM_METADATA_BITPOS 174
#define CFA_P58_PROF_L2_CTXT_TCAM_METADATA_NUM_BITS 16

/* ROCE Packet detected by the Parser (for idx 5 ...) */
#define CFA_P58_PROF_L2_CTXT_TCAM_ROCE_BITPOS 173
#define CFA_P58_PROF_L2_CTXT_TCAM_ROCE_NUM_BITS 1

/* LLC Packet detected by the Parser. (for idx 5 ...) */
#define CFA_P58_PROF_L2_CTXT_TCAM_LLC_BITPOS 172
#define CFA_P58_PROF_L2_CTXT_TCAM_LLC_NUM_BITS 1

/* 4b encoding for Tunnel Type (for idx 5 ...) */
#define CFA_P58_PROF_L2_CTXT_TCAM_T_HDR_TYPE_BITPOS 168
#define CFA_P58_PROF_L2_CTXT_TCAM_T_HDR_TYPE_NUM_BITS 4

/* FLDS Tunnel Status ID. */
#define CFA_P58_PROF_L2_CTXT_TCAM_TUNNEL_ID_BITPOS 144
#define CFA_P58_PROF_L2_CTXT_TCAM_TUNNEL_ID_NUM_BITS 24

/* Selected tunnel/inner DMAC/SMAC */
#define CFA_P58_PROF_L2_CTXT_TCAM_MAC0_BITPOS 96
#define CFA_P58_PROF_L2_CTXT_TCAM_MAC0_NUM_BITS 48

/* Selected tunnel/inner DMAC/SMAC Each of these fields are from the selected
 * tunnel/inner L2 header
 */
#define CFA_P58_PROF_L2_CTXT_TCAM_MAC1_BITPOS 48
#define CFA_P58_PROF_L2_CTXT_TCAM_MAC1_NUM_BITS 48

/* 1+ VLAN tags present (for idx 1 ...) */
#define CFA_P58_PROF_L2_CTXT_TCAM_TL2_L2_VTAG_PRESENT_BITPOS 47
#define CFA_P58_PROF_L2_CTXT_TCAM_TL2_L2_VTAG_PRESENT_NUM_BITS 1

/* 2 VLAN tags present (for idx 1 ...) */
#define CFA_P58_PROF_L2_CTXT_TCAM_TL2_L2_TWO_VTAGS_BITPOS 46
#define CFA_P58_PROF_L2_CTXT_TCAM_TL2_L2_TWO_VTAGS_NUM_BITS 1

/* Outer VLAN tag VID (for idx 1 ...) */
#define CFA_P58_PROF_L2_CTXT_TCAM_TL2_L2_OVLAN_VID_BITPOS 34
#define CFA_P58_PROF_L2_CTXT_TCAM_TL2_L2_OVLAN_VID_NUM_BITS 12

/* Outer VLAN tag 3b encoded TPID */
#define CFA_P58_PROF_L2_CTXT_TCAM_TL2_L2_OVLAN_TPID_SEL_BITPOS 31
#define CFA_P58_PROF_L2_CTXT_TCAM_TL2_L2_OVLAN_TPID_SEL_NUM_BITS 3

/* Inner VLAN tag VID */
#define CFA_P58_PROF_L2_CTXT_TCAM_TL2_L2_IVLAN_VID_BITPOS 19
#define CFA_P58_PROF_L2_CTXT_TCAM_TL2_L2_IVLAN_VID_NUM_BITS 12

/* Inner VLAN tag 3b encoded TPID */
#define CFA_P58_PROF_L2_CTXT_TCAM_TL2_L2_IVLAN_TPID_SEL_BITPOS 16
#define CFA_P58_PROF_L2_CTXT_TCAM_TL2_L2_IVLAN_TPID_SEL_NUM_BITS 3

/* Ethertype. */
#define CFA_P58_PROF_L2_CTXT_TCAM_TL2_L2_ETYPE_BITPOS 0
#define CFA_P58_PROF_L2_CTXT_TCAM_TL2_L2_ETYPE_NUM_BITS 16

enum cfa_p58_prof_l2_ctxt_tcam_flds {
	CFA_P58_PROF_L2_CTXT_TCAM_VALID_FLD = 0,
	CFA_P58_PROF_L2_CTXT_TCAM_MPASS_CNT_FLD = 1,
	CFA_P58_PROF_L2_CTXT_TCAM_RCYC_FLD = 2,
	CFA_P58_PROF_L2_CTXT_TCAM_LOOPBACK_FLD = 3,
	CFA_P58_PROF_L2_CTXT_TCAM_SPIF_FLD = 4,
	CFA_P58_PROF_L2_CTXT_TCAM_PARIF_FLD = 5,
	CFA_P58_PROF_L2_CTXT_TCAM_SVIF_FLD = 6,
	CFA_P58_PROF_L2_CTXT_TCAM_METADATA_FLD = 7,
	CFA_P58_PROF_L2_CTXT_TCAM_ROCE_FLD = 8,
	CFA_P58_PROF_L2_CTXT_TCAM_LLC_FLD = 9,
	CFA_P58_PROF_L2_CTXT_TCAM_T_HDR_TYPE_FLD = 10,
	CFA_P58_PROF_L2_CTXT_TCAM_TUNNEL_ID_FLD = 11,
	CFA_P58_PROF_L2_CTXT_TCAM_MAC0_FLD = 12,
	CFA_P58_PROF_L2_CTXT_TCAM_MAC1_FLD = 13,
	CFA_P58_PROF_L2_CTXT_TCAM_TL2_L2_VTAG_PRESENT_FLD = 14,
	CFA_P58_PROF_L2_CTXT_TCAM_TL2_L2_TWO_VTAGS_FLD = 15,
	CFA_P58_PROF_L2_CTXT_TCAM_TL2_L2_OVLAN_VID_FLD = 16,
	CFA_P58_PROF_L2_CTXT_TCAM_TL2_L2_OVLAN_TPID_SEL_FLD = 17,
	CFA_P58_PROF_L2_CTXT_TCAM_TL2_L2_IVLAN_VID_FLD = 18,
	CFA_P58_PROF_L2_CTXT_TCAM_TL2_L2_IVLAN_TPID_SEL_FLD = 19,
	CFA_P58_PROF_L2_CTXT_TCAM_TL2_L2_ETYPE_FLD = 20,
	CFA_P58_PROF_L2_CTXT_TCAM_MAX_FLD
};

#define CFA_P58_PROF_L2_CTXT_TCAM_TOTAL_NUM_BITS 213

/* Valid(1)/Invalid(0) TCAM entry. (for idx 2 ...) */
#define CFA_P58_PROF_PROFILE_TCAM_VALID_BITPOS 93
#define CFA_P58_PROF_PROFILE_TCAM_VALID_NUM_BITS 1

/* Packet type directly from prof_in. (for idx 2 ...) */
#define CFA_P58_PROF_PROFILE_TCAM_PKT_TYPE_BITPOS 89
#define CFA_P58_PROF_PROFILE_TCAM_PKT_TYPE_NUM_BITS 4

/* From L2 Context Lookup stage. (for idx 2 ...) */
#define CFA_P58_PROF_PROFILE_TCAM_METADATA_BITPOS 73
#define CFA_P58_PROF_PROFILE_TCAM_METADATA_NUM_BITS 16

/* Aggregate error flag from Input stage. (for idx 2 ...) */
#define CFA_P58_PROF_PROFILE_TCAM_AGG_ERROR_BITPOS 72
#define CFA_P58_PROF_PROFILE_TCAM_AGG_ERROR_NUM_BITS 1

/* Profile function from L2 Context Lookup stage. (for idx 2 ...) */
#define CFA_P58_PROF_PROFILE_TCAM_PROF_FUNC_BITPOS 65
#define CFA_P58_PROF_PROFILE_TCAM_PROF_FUNC_NUM_BITS 7

/* From FLDS Input General Status tunnel(1)/no tunnel(0) (for idx 2 ...) */
#define CFA_P58_PROF_PROFILE_TCAM_HREC_NEXT_BITPOS 64
#define CFA_P58_PROF_PROFILE_TCAM_HREC_NEXT_NUM_BITS 1

/* resolved flds_tl2_hdr_valid. (for idx 1 ...) */
#define CFA_P58_PROF_PROFILE_TCAM_TL2_HDR_VALID_BITPOS 63
#define CFA_P58_PROF_PROFILE_TCAM_TL2_HDR_VALID_NUM_BITS 1

/* Tunnel L2 header type directly from FLDS. (for idx 1 ...) */
#define CFA_P58_PROF_PROFILE_TCAM_TL2_HDR_TYPE_BITPOS 61
#define CFA_P58_PROF_PROFILE_TCAM_TL2_HDR_TYPE_NUM_BITS 2

/* flds_tl2_dst_type remapped: UC(0)/MC(2)/BC(3) (for idx 1 ...) */
#define CFA_P58_PROF_PROFILE_TCAM_TL2_UC_MC_BC_BITPOS 59
#define CFA_P58_PROF_PROFILE_TCAM_TL2_UC_MC_BC_NUM_BITS 2

/* 1+ VLAN tags present in Tunnel L2 header (for idx 1 ...) */
#define CFA_P58_PROF_PROFILE_TCAM_TL2_VTAG_PRESENT_BITPOS 58
#define CFA_P58_PROF_PROFILE_TCAM_TL2_VTAG_PRESENT_NUM_BITS 1

/* 2 VLAN tags present in Tunnel L2 header (for idx 1 ...) */
#define CFA_P58_PROF_PROFILE_TCAM_TL2_TWO_VTAGS_BITPOS 57
#define CFA_P58_PROF_PROFILE_TCAM_TL2_TWO_VTAGS_NUM_BITS 1

/* resolved flds_tl3_hdr_valid. (for idx 1 ...) */
#define CFA_P58_PROF_PROFILE_TCAM_TL3_HDR_VALID_BITPOS 56
#define CFA_P58_PROF_PROFILE_TCAM_TL3_HDR_VALID_NUM_BITS 1

/* flds_tl3_hdr_valid is stop_w_error. (for idx 1 ...) */
#define CFA_P58_PROF_PROFILE_TCAM_TL3_HDR_ERROR_BITPOS 55
#define CFA_P58_PROF_PROFILE_TCAM_TL3_HDR_ERROR_NUM_BITS 1

/* Tunnel L3 header type directly from FLDS. (for idx 1 ...) */
#define CFA_P58_PROF_PROFILE_TCAM_TL3_HDR_TYPE_BITPOS 51
#define CFA_P58_PROF_PROFILE_TCAM_TL3_HDR_TYPE_NUM_BITS 4

/* Tunnel L3 header is IPV4 or IPV6. (for idx 1 ...) */
#define CFA_P58_PROF_PROFILE_TCAM_TL3_HDR_ISIP_BITPOS 50
#define CFA_P58_PROF_PROFILE_TCAM_TL3_HDR_ISIP_NUM_BITS 1

/* Tunnel L3 IPV6 source address is compressed. (for idx 1 ...) */
#define CFA_P58_PROF_PROFILE_TCAM_TL3_IPV6_CMP_SRC_BITPOS 49
#define CFA_P58_PROF_PROFILE_TCAM_TL3_IPV6_CMP_SRC_NUM_BITS 1

/* Tunnel L3 IPV6 destination address is compressed. (for idx 1 ...) */
#define CFA_P58_PROF_PROFILE_TCAM_TL3_IPV6_CMP_DST_BITPOS 48
#define CFA_P58_PROF_PROFILE_TCAM_TL3_IPV6_CMP_DST_NUM_BITS 1

/* resolved flds_tl4_hdr_valid. (for idx 1 ...) */
#define CFA_P58_PROF_PROFILE_TCAM_TL4_HDR_VALID_BITPOS 47
#define CFA_P58_PROF_PROFILE_TCAM_TL4_HDR_VALID_NUM_BITS 1

/* flds_tl4_hdr_valid is stop_w_error. (for idx 1 ...) */
#define CFA_P58_PROF_PROFILE_TCAM_TL4_HDR_ERROR_BITPOS 46
#define CFA_P58_PROF_PROFILE_TCAM_TL4_HDR_ERROR_NUM_BITS 1

/* Tunnel L4 header type directly from FLDS. (for idx 1 ...) */
#define CFA_P58_PROF_PROFILE_TCAM_TL4_HDR_TYPEP_BITPOS 42
#define CFA_P58_PROF_PROFILE_TCAM_TL4_HDR_TYPEP_NUM_BITS 4

/* TL4 header is UDP or TCP. (for idx 1 ...) */
#define CFA_P58_PROF_PROFILE_TCAM_TL4_HDR_IS_UDP_TCP_BITPOS 41
#define CFA_P58_PROF_PROFILE_TCAM_TL4_HDR_IS_UDP_TCP_NUM_BITS 1

/* resolved flds_tun_hdr_valid. (for idx 1 ...) */
#define CFA_P58_PROF_PROFILE_TCAM_TUN_HDR_VALID_BITPOS 40
#define CFA_P58_PROF_PROFILE_TCAM_TUN_HDR_VALID_NUM_BITS 1

/* flds_tun_hdr_valid is stop_w_error. (for idx 1 ...) */
#define CFA_P58_PROF_PROFILE_TCAM_TUN_HDR_ERROR_BITPOS 39
#define CFA_P58_PROF_PROFILE_TCAM_TUN_HDR_ERROR_NUM_BITS 1

/* Tunnel header type directly from FLDS. (for idx 1 ...) */
#define CFA_P58_PROF_PROFILE_TCAM_TUN_HDR_TYPE_BITPOS 35
#define CFA_P58_PROF_PROFILE_TCAM_TUN_HDR_TYPE_NUM_BITS 4

/* Tunnel header flags directly from FLDS. (for idx 1 ...) */
#define CFA_P58_PROF_PROFILE_TCAM_TUN_HDR_FLAGS_BITPOS 32
#define CFA_P58_PROF_PROFILE_TCAM_TUN_HDR_FLAGS_NUM_BITS 3

/* resolved flds_l2_hdr_valid. */
#define CFA_P58_PROF_PROFILE_TCAM_L2_HDR_VALID_BITPOS 31
#define CFA_P58_PROF_PROFILE_TCAM_L2_HDR_VALID_NUM_BITS 1

/* flds_l2_hdr_valid is stop_w_error. */
#define CFA_P58_PROF_PROFILE_TCAM_L2_HDR_ERROR_BITPOS 30
#define CFA_P58_PROF_PROFILE_TCAM_L2_HDR_ERROR_NUM_BITS 1

/* L2 header type directly from FLDS. */
#define CFA_P58_PROF_PROFILE_TCAM_L2_HDR_TYPE_BITPOS 28
#define CFA_P58_PROF_PROFILE_TCAM_L2_HDR_TYPE_NUM_BITS 2

/* flds_l2_dst_type remapped: UC(0)/MC(2)/BC(3). */
#define CFA_P58_PROF_PROFILE_TCAM_L2_UC_MC_BC_BITPOS 26
#define CFA_P58_PROF_PROFILE_TCAM_L2_UC_MC_BC_NUM_BITS 2

/* 1+ VLAN tags present in inner L2 header. */
#define CFA_P58_PROF_PROFILE_TCAM_L2_VTAG_PRESENT_BITPOS 25
#define CFA_P58_PROF_PROFILE_TCAM_L2_VTAG_PRESENT_NUM_BITS 1

/* 2 VLAN tags present in inner L2 header. */
#define CFA_P58_PROF_PROFILE_TCAM_L2_TWO_VTAGS_BITPOS 24
#define CFA_P58_PROF_PROFILE_TCAM_L2_TWO_VTAGS_NUM_BITS 1

/* resolved flds_l3_hdr_valid. */
#define CFA_P58_PROF_PROFILE_TCAM_L3_HDR_VALID_BITPOS 23
#define CFA_P58_PROF_PROFILE_TCAM_L3_HDR_VALID_NUM_BITS 1

/* flds_l3_hdr_valid is stop_w_error. */
#define CFA_P58_PROF_PROFILE_TCAM_L3_HDR_ERROR_BITPOS 22
#define CFA_P58_PROF_PROFILE_TCAM_L3_HDR_ERROR_NUM_BITS 1

/* L3 header type directly from FLDS. */
#define CFA_P58_PROF_PROFILE_TCAM_L3_HDR_TYPE_BITPOS 18
#define CFA_P58_PROF_PROFILE_TCAM_L3_HDR_TYPE_NUM_BITS 4

/* L3 header is IPV4 or IPV6. */
#define CFA_P58_PROF_PROFILE_TCAM_L3_HDR_ISIP_BITPOS 17
#define CFA_P58_PROF_PROFILE_TCAM_L3_HDR_ISIP_NUM_BITS 1

/* L3 header IPV6 source address is compressed. */
#define CFA_P58_PROF_PROFILE_TCAM_L3_IPV6_CMP_SRC_BITPOS 16
#define CFA_P58_PROF_PROFILE_TCAM_L3_IPV6_CMP_SRC_NUM_BITS 1

/* L3 header IPV6 destination address is compressed. */
#define CFA_P58_PROF_PROFILE_TCAM_L3_IPV6_CMP_DST_BITPOS 15
#define CFA_P58_PROF_PROFILE_TCAM_L3_IPV6_CMP_DST_NUM_BITS 1

/* IP extension hdr of L3 Status. */
#define CFA_P58_PROF_PROFILE_TCAM_IEH_BITPOS 7
#define CFA_P58_PROF_PROFILE_TCAM_IEH_NUM_BITS 8

/* resolved flds_l4_hdr_valid. */
#define CFA_P58_PROF_PROFILE_TCAM_L4_HDR_VALID_BITPOS 6
#define CFA_P58_PROF_PROFILE_TCAM_L4_HDR_VALID_NUM_BITS 1

/* flds_l4_hdr_valid is stop_w_error. */
#define CFA_P58_PROF_PROFILE_TCAM_L4_HDR_ERROR_BITPOS 5
#define CFA_P58_PROF_PROFILE_TCAM_L4_HDR_ERROR_NUM_BITS 1

/* L4 header type directly from FLDS. */
#define CFA_P58_PROF_PROFILE_TCAM_L4_HDR_TYPE_BITPOS 1
#define CFA_P58_PROF_PROFILE_TCAM_L4_HDR_TYPE_NUM_BITS 4

/* L4 header is UDP or TCP.2 */
#define CFA_P58_PROF_PROFILE_TCAM_L4_HDR_IS_UDP_TCP_BITPOS 0
#define CFA_P58_PROF_PROFILE_TCAM_L4_HDR_IS_UDP_TCP_NUM_BITS 1

enum cfa_p58_prof_profile_tcam_flds {
	CFA_P58_PROF_PROFILE_TCAM_VALID_FLD = 0,
	CFA_P58_PROF_PROFILE_TCAM_PKT_TYPE_FLD = 1,
	CFA_P58_PROF_PROFILE_TCAM_METADATA_FLD = 2,
	CFA_P58_PROF_PROFILE_TCAM_AGG_ERROR_FLD = 3,
	CFA_P58_PROF_PROFILE_TCAM_PROF_FUNC_FLD = 4,
	CFA_P58_PROF_PROFILE_TCAM_HREC_NEXT_FLD = 5,
	CFA_P58_PROF_PROFILE_TCAM_TL2_HDR_VALID_FLD = 6,
	CFA_P58_PROF_PROFILE_TCAM_TL2_HDR_TYPE_FLD = 7,
	CFA_P58_PROF_PROFILE_TCAM_TL2_UC_MC_BC_FLD = 8,
	CFA_P58_PROF_PROFILE_TCAM_TL2_VTAG_PRESENT_FLD = 9,
	CFA_P58_PROF_PROFILE_TCAM_TL2_TWO_VTAGS_FLD = 10,
	CFA_P58_PROF_PROFILE_TCAM_TL3_HDR_VALID_FLD = 11,
	CFA_P58_PROF_PROFILE_TCAM_TL3_HDR_ERROR_FLD = 12,
	CFA_P58_PROF_PROFILE_TCAM_TL3_HDR_TYPE_FLD = 13,
	CFA_P58_PROF_PROFILE_TCAM_TL3_HDR_ISIP_FLD = 14,
	CFA_P58_PROF_PROFILE_TCAM_TL3_IPV6_CMP_SRC_FLD = 15,
	CFA_P58_PROF_PROFILE_TCAM_TL3_IPV6_CMP_DST_FLD = 16,
	CFA_P58_PROF_PROFILE_TCAM_TL4_HDR_VALID_FLD = 17,
	CFA_P58_PROF_PROFILE_TCAM_TL4_HDR_ERROR_FLD = 18,
	CFA_P58_PROF_PROFILE_TCAM_TL4_HDR_TYPEP_FLD = 19,
	CFA_P58_PROF_PROFILE_TCAM_TL4_HDR_IS_UDP_TCP_FLD = 20,
	CFA_P58_PROF_PROFILE_TCAM_TUN_HDR_VALID_FLD = 21,
	CFA_P58_PROF_PROFILE_TCAM_TUN_HDR_ERROR_FLD = 22,
	CFA_P58_PROF_PROFILE_TCAM_TUN_HDR_TYPE_FLD = 23,
	CFA_P58_PROF_PROFILE_TCAM_TUN_HDR_FLAGS_FLD = 24,
	CFA_P58_PROF_PROFILE_TCAM_L2_HDR_VALID_FLD = 25,
	CFA_P58_PROF_PROFILE_TCAM_L2_HDR_ERROR_FLD = 26,
	CFA_P58_PROF_PROFILE_TCAM_L2_HDR_TYPE_FLD = 27,
	CFA_P58_PROF_PROFILE_TCAM_L2_UC_MC_BC_FLD = 28,
	CFA_P58_PROF_PROFILE_TCAM_L2_VTAG_PRESENT_FLD = 29,
	CFA_P58_PROF_PROFILE_TCAM_L2_TWO_VTAGS_FLD = 30,
	CFA_P58_PROF_PROFILE_TCAM_L3_HDR_VALID_FLD = 31,
	CFA_P58_PROF_PROFILE_TCAM_L3_HDR_ERROR_FLD = 32,
	CFA_P58_PROF_PROFILE_TCAM_L3_HDR_TYPE_FLD = 33,
	CFA_P58_PROF_PROFILE_TCAM_L3_HDR_ISIP_FLD = 34,
	CFA_P58_PROF_PROFILE_TCAM_L3_IPV6_CMP_SRC_FLD = 35,
	CFA_P58_PROF_PROFILE_TCAM_L3_IPV6_CMP_DST_FLD = 36,
	CFA_P58_PROF_PROFILE_TCAM_IEH_FLD = 37,
	CFA_P58_PROF_PROFILE_TCAM_L4_HDR_VALID_FLD = 38,
	CFA_P58_PROF_PROFILE_TCAM_L4_HDR_ERROR_FLD = 39,
	CFA_P58_PROF_PROFILE_TCAM_L4_HDR_TYPE_FLD = 40,
	CFA_P58_PROF_PROFILE_TCAM_L4_HDR_IS_UDP_TCP_FLD = 41,
	CFA_P58_PROF_PROFILE_TCAM_MAX_FLD
};

#define CFA_P58_PROF_PROFILE_TCAM_TOTAL_NUM_BITS 94

/* IPv4 ID field control.
 *
 * The enumerators are renamed from the autogenerated name
 * to avoid redeclaration.
 */
#define CFA_P58_ACTP5_TECT_IPV4_ID_CTRL_BITPOS 16
#define CFA_P58_ACTP5_TECT_IPV4_ID_CTRL_NUM_BITS 2
enum cfa_p58_actp5_tect_ipv4_id_ctrl {
	/* use IPv4 ID field from encapsulation record */
	CFA_P58_ACTP5_TECT_IPV4_ID_CTRL_ENCREC = 0x0UL,
	/* reserved */
	CFA_P58_ACTP5_TECT_IPV4_ID_CTRL_RSVD = 0x1UL,
	/* inherit inner IPv4 header ID field */
	CFA_P58_ACTP5_TECT_IPV4_ID_CTRL_INHRT = 0x2UL,
	/* use CFA incrementing IPv4 ID counter */
	CFA_P58_ACTP5_TECT_IPV4_ID_CTRL_INCR = 0x3UL,
	CFA_P58_ACTP5_TECT_IPV4_ID_CTRL_MAX = 0x3UL
};

/* SMAC override.
 *
 * The enumerators are renamed from the autogenerated name
 * to avoid redeclaration.
 */
#define CFA_P58_ACTP5_TECT_SMAC_OVR_BITPOS 13
#define CFA_P58_ACTP5_TECT_SMAC_OVR_NUM_BITS 3
enum cfa_p58_actp5_tect_smac_ovr {
	/* use source property record SMAC */
	CFA_P58_ACTP5_TECT_SMAC_OVR_ENCP = 0x0UL,
	/* re-use existing inner L2 header SMAC */
	CFA_P58_ACTP5_TECT_SMAC_OVR_RUINSL2 = 0x1UL,
	/* re-use existing tunnel L2 header SMAC */
	CFA_P58_ACTP5_TECT_SMAC_OVR_RUTNSL2 = 0x2UL,
	/* re-use existing outer-most L2 header SMAC */
	CFA_P58_ACTP5_TECT_SMAC_OVR_RUOMSL2 = 0x3UL,
	/* reserved for future use */
	CFA_P58_ACTP5_TECT_SMAC_OVR_RSVDL2 = 0x4UL,
	/* re-use existing inner L2 header DMAC */
	CFA_P58_ACTP5_TECT_SMAC_OVR_RUINDL2 = 0x5UL,
	/* re-use existing tunnel L2 header DMAC */
	CFA_P58_ACTP5_TECT_SMAC_OVR_RUTNDL2 = 0x6UL,
	/* re-use existing outer-most L2 header DMAC */
	CFA_P58_ACTP5_TECT_SMAC_OVR_RUOMDL2 = 0x7UL,
	CFA_P58_ACTP5_TECT_SMAC_OVR_MAX = 0x7UL
};

/* VLAN override.
 *
 * The enumerators are renamed from the autogenerated name
 * to avoid redeclaration.
 */
#define CFA_P58_ACTP5_TECT_VLAN_OVR_BITPOS 10
#define CFA_P58_ACTP5_TECT_VLAN_OVR_NUM_BITS 3
enum cfa_p58_actp5_tect_vlan_ovr {
	/* use only encap record VLAN tags */
	CFA_P58_ACTP5_TECT_VLAN_OVR_ENCP = 0x0UL,
	/* use only existing inner L2 header VLAN tags */
	CFA_P58_ACTP5_TECT_VLAN_OVR_RUINL2 = 0x1UL,
	/* use only existing tunnel L2 VLAN tags */
	CFA_P58_ACTP5_TECT_VLAN_OVR_RUTNL2 = 0x2UL,
	/* use only existing outer-most L2 VLAN tags */
	CFA_P58_ACTP5_TECT_VLAN_OVR_RUOML2 = 0x3UL,
	/* include inner VLAN tag inner L2 header. */
	CFA_P58_ACTP5_TECT_VLAN_OVR_INCIVL2 = 0x4UL,
	/* include outer VLAN tag inner L2 header */
	CFA_P58_ACTP5_TECT_VLAN_OVR_INCOVL2 = 0x5UL,
	/* include inner VLAN tag outer-most L2 header */
	CFA_P58_ACTP5_TECT_VLAN_OVR_INCIVOM = 0x6UL,
	/* include outer VLAN tag outer-most L2 header */
	CFA_P58_ACTP5_TECT_VLAN_OVR_INCOVOM = 0x7UL,
	CFA_P58_ACTP5_TECT_VLAN_OVR_MAX = 0x7UL
};

/* DMAC override.
 *
 * The enumerators are renamed from the autogenerated name
 * to avoid redeclaration.
 */
#define CFA_P58_ACTP5_TECT_DMAC_OVR_BITPOS 8
#define CFA_P58_ACTP5_TECT_DMAC_OVR_NUM_BITS 2
enum cfa_p58_actp5_tect_dmac_ovr {
	/* use encap record DMAC */
	CFA_P58_ACTP5_TECT_DMAC_OVR_ENCP = 0x0UL,
	/* re-use existing inner L2 header DMAC */
	CFA_P58_ACTP5_TECT_DMAC_OVR_RUINL2 = 0x1UL,
	/* re-use existing tunnel L2 header DMAC */
	CFA_P58_ACTP5_TECT_DMAC_OVR_RUTNL2 = 0x2UL,
	/* re-use existing outer-most L2 header DMAC */
	CFA_P58_ACTP5_TECT_DMAC_OVR_RUOML2 = 0x3UL,
	CFA_P58_ACTP5_TECT_DMAC_OVR_MAX = 0x3UL
};

/* When set to 1 any GRE tunnels will include the optional Key field. */
#define CFA_P58_ACTP5_TECT_GRE_SET_K_BITPOS 7
#define CFA_P58_ACTP5_TECT_GRE_SET_K_NUM_BITS 1

/* Default Tunnel QOS placed in fields bus on tunnel encapsulations. */
#define CFA_P58_ACTP5_TECT_TUN_QOS_BITPOS 4
#define CFA_P58_ACTP5_TECT_TUN_QOS_NUM_BITS 3

/* When set to 1 the IPV6 Traffic Class (TC) field of the outer header is
 * inherited from the inner header (if present) or the fixed value as taken
 * from the encap record.
 */
#define CFA_P58_ACTP5_TECT_IPV6_TC_IH_BITPOS 3
#define CFA_P58_ACTP5_TECT_IPV6_TC_IH_NUM_BITS 1

/* When set to 1 the IPV6 Hop Limit field of the outer header is inherited
 * from the inner header (if present) or the fixed value as taken from the
 * encap record.
 */
#define CFA_P58_ACTP5_TECT_IPV6_HL_IH_BITPOS 2
#define CFA_P58_ACTP5_TECT_IPV6_HL_IH_NUM_BITS 1

/* When set to 1 the IPV4 Type Of Service (TOS) field of the outer header is
 * inherited from the inner header (if present) or the fixed value as taken
 * from the encap record.
 */
#define CFA_P58_ACTP5_TECT_IPV4_TOS_IH_BITPOS 1
#define CFA_P58_ACTP5_TECT_IPV4_TOS_IH_NUM_BITS 1

/* When set to 1 the IPV4 TTL field of the outer header is inherited from the
 * inner header (if present) or the fixed value as taken from the encap
 * record.
 */
#define CFA_P58_ACTP5_TECT_IPV4_TTL_IH_BITPOS 0
#define CFA_P58_ACTP5_TECT_IPV4_TTL_IH_NUM_BITS 1

enum cfa_p58_actp5_tect_flds {
	CFA_P58_ACTP5_TECT_IPV4_ID_CTRL_FLD = 0,
	CFA_P58_ACTP5_TECT_SMAC_OVR_FLD = 1,
	CFA_P58_ACTP5_TECT_VLAN_OVR_FLD = 2,
	CFA_P58_ACTP5_TECT_DMAC_OVR_FLD = 3,
	CFA_P58_ACTP5_TECT_GRE_SET_K_FLD = 4,
	CFA_P58_ACTP5_TECT_TUN_QOS_FLD = 5,
	CFA_P58_ACTP5_TECT_IPV6_TC_IH_FLD = 6,
	CFA_P58_ACTP5_TECT_IPV6_HL_IH_FLD = 7,
	CFA_P58_ACTP5_TECT_IPV4_TOS_IH_FLD = 8,
	CFA_P58_ACTP5_TECT_IPV4_TTL_IH_FLD = 9,
	CFA_P58_ACTP5_TECT_MAX_FLD
};

#define CFA_P58_ACTP5_TECT_TOTAL_NUM_BITS 18

/* Valid entry (for idx 2 ...) */
#define CFA_P58_ACTP5_VEB_TCAM_TX_VALID_BITPOS 78
#define CFA_P58_ACTP5_VEB_TCAM_TX_VALID_NUM_BITS 1

/* PF Parif Number (for idx 2 ...) */
#define CFA_P58_ACTP5_VEB_TCAM_TX_PARIF_IN_BITPOS 74
#define CFA_P58_ACTP5_VEB_TCAM_TX_PARIF_IN_NUM_BITS 4

/* Number of VLAN Tags. (for idx 2 ...) */
#define CFA_P58_ACTP5_VEB_TCAM_TX_NUM_VTAGS_BITPOS 72
#define CFA_P58_ACTP5_VEB_TCAM_TX_NUM_VTAGS_NUM_BITS 2

/* Dest. MAC Address */
#define CFA_P58_ACTP5_VEB_TCAM_TX_DMAC_BITPOS 24
#define CFA_P58_ACTP5_VEB_TCAM_TX_DMAC_NUM_BITS 48

/* Outer VLAN Tag ID */
#define CFA_P58_ACTP5_VEB_TCAM_TX_OVID_BITPOS 12
#define CFA_P58_ACTP5_VEB_TCAM_TX_OVID_NUM_BITS 12

/* Inner VLAN Tag ID RX Fields (Source Knockout Mode): */
#define CFA_P58_ACTP5_VEB_TCAM_TX_IVID_BITPOS 0
#define CFA_P58_ACTP5_VEB_TCAM_TX_IVID_NUM_BITS 12

/* Valid entry (for idx 2 ...) */
#define CFA_P58_ACTP5_VEB_TCAM_RX_VALID_BITPOS 78
#define CFA_P58_ACTP5_VEB_TCAM_RX_VALID_NUM_BITS 1

/* program to zero (for idx 2 ...) */
#define CFA_P58_ACTP5_VEB_TCAM_RX_PADDING_BITPOS 67
#define CFA_P58_ACTP5_VEB_TCAM_RX_PADDING_NUM_BITS 11

/* DMAC is unicast address (for idx 2 ...) */
#define CFA_P58_ACTP5_VEB_TCAM_RX_UNICAST_BITPOS 66
#define CFA_P58_ACTP5_VEB_TCAM_RX_UNICAST_NUM_BITS 1

/* DMAC is multicast address (for idx 2 ...) */
#define CFA_P58_ACTP5_VEB_TCAM_RX_MULTICAST_BITPOS 65
#define CFA_P58_ACTP5_VEB_TCAM_RX_MULTICAST_NUM_BITS 1

/* DMAC is broadcast address (for idx 2 ...) */
#define CFA_P58_ACTP5_VEB_TCAM_RX_BROADCAST_BITPOS 64
#define CFA_P58_ACTP5_VEB_TCAM_RX_BROADCAST_NUM_BITS 1

/* pfid (for idx 1 ...) */
#define CFA_P58_ACTP5_VEB_TCAM_RX_PFID_BITPOS 60
#define CFA_P58_ACTP5_VEB_TCAM_RX_PFID_NUM_BITS 4

/* vfid (for idx 1 ...) */
#define CFA_P58_ACTP5_VEB_TCAM_RX_VFID_BITPOS 48
#define CFA_P58_ACTP5_VEB_TCAM_RX_VFID_NUM_BITS 12

/* source mac */
#define CFA_P58_ACTP5_VEB_TCAM_RX_SMAC_BITPOS 0
#define CFA_P58_ACTP5_VEB_TCAM_RX_SMAC_NUM_BITS 48

enum cfa_p58_actp5_veb_tcam_flds {
	CFA_P58_ACTP5_VEB_TCAM_TX_VALID_FLD = 0,
	CFA_P58_ACTP5_VEB_TCAM_TX_PARIF_IN_FLD = 1,
	CFA_P58_ACTP5_VEB_TCAM_TX_NUM_VTAGS_FLD = 2,
	CFA_P58_ACTP5_VEB_TCAM_TX_DMAC_FLD = 3,
	CFA_P58_ACTP5_VEB_TCAM_TX_OVID_FLD = 4,
	CFA_P58_ACTP5_VEB_TCAM_TX_IVID_FLD = 5,
	CFA_P58_ACTP5_VEB_TCAM_RX_VALID_FLD = 6,
	CFA_P58_ACTP5_VEB_TCAM_RX_PADDING_FLD = 7,
	CFA_P58_ACTP5_VEB_TCAM_RX_UNICAST_FLD = 8,
	CFA_P58_ACTP5_VEB_TCAM_RX_MULTICAST_FLD = 9,
	CFA_P58_ACTP5_VEB_TCAM_RX_BROADCAST_FLD = 10,
	CFA_P58_ACTP5_VEB_TCAM_RX_PFID_FLD = 11,
	CFA_P58_ACTP5_VEB_TCAM_RX_VFID_FLD = 12,
	CFA_P58_ACTP5_VEB_TCAM_RX_SMAC_FLD = 13,
	CFA_P58_ACTP5_VEB_TCAM_MAX_FLD
};

#define CFA_P58_ACTP5_VEB_TCAM_TOTAL_NUM_BITS 158

/* Partition (for idx 1 ...) */
#define CFA_P58_PROF_INPUT_LOOKUP_TABLE_MEM_PARIF_BITPOS 37
#define CFA_P58_PROF_INPUT_LOOKUP_TABLE_MEM_PARIF_NUM_BITS 4

/* When set cfa_meta opcode is allowed (for idx 1 ...) */
#define CFA_P58_PROF_INPUT_LOOKUP_TABLE_MEM_EN_BD_META_BITPOS 36
#define CFA_P58_PROF_INPUT_LOOKUP_TABLE_MEM_EN_BD_META_NUM_BITS 1

/* When set act_rec_ptr is set to cfa_action if it is non-zero. Otherwise
 * act_rec_ptr is set to act_rec_ptr from this table. (for idx 1 ...)
 */
#define CFA_P58_PROF_INPUT_LOOKUP_TABLE_MEM_EN_BD_ACTION_BITPOS 35
#define CFA_P58_PROF_INPUT_LOOKUP_TABLE_MEM_EN_BD_ACTION_NUM_BITS 1

/* When set destination is set to destination from this table. Otherwise it is
 * set to est_dest. (for idx 1 ...)
 */
#define CFA_P58_PROF_INPUT_LOOKUP_TABLE_MEM_EN_ILT_DEST_BITPOS 34
#define CFA_P58_PROF_INPUT_LOOKUP_TABLE_MEM_EN_ILT_DEST_NUM_BITS 1

/* ILT opcode (for idx 1 ...) */
#define CFA_P58_PROF_INPUT_LOOKUP_TABLE_MEM_FWD_OP_BITPOS 32
#define CFA_P58_PROF_INPUT_LOOKUP_TABLE_MEM_FWD_OP_NUM_BITS 2
enum cfa_p58_prof_input_lookup_table_mem_fwd_op {
	/* cfa is bypassed */
	CFA_P58_PROF_INPUT_LOOKUP_TABLE_MEM_BYPASS_CFA = 0x0UL,
	/* cfa is bypassed if packet is ROCE */
	CFA_P58_PROF_INPUT_LOOKUP_TABLE_MEM_BYPASS_CFA_ROCE = 0x1UL,
	/* profiler and lookup blocks are bypassed */
	CFA_P58_PROF_INPUT_LOOKUP_TABLE_MEM_BYPASS_LKUP = 0x2UL,
	/* packet proceeds to L2 Context Stage */
	CFA_P58_PROF_INPUT_LOOKUP_TABLE_MEM_NORMAL_FLOW = 0x3UL,
	CFA_P58_PROF_INPUT_LOOKUP_TABLE_MEM_MAX = 0x3UL
};

/* used for act_rec_ptr */
#define CFA_P58_PROF_INPUT_LOOKUP_TABLE_MEM_ACT_REC_PTR_BITPOS 16
#define CFA_P58_PROF_INPUT_LOOKUP_TABLE_MEM_ACT_REC_PTR_NUM_BITS 16

/* used for destination */
#define CFA_P58_PROF_INPUT_LOOKUP_TABLE_MEM_DESTINATION_BITPOS 0
#define CFA_P58_PROF_INPUT_LOOKUP_TABLE_MEM_DESTINATION_NUM_BITS 16

enum cfa_p58_prof_input_lookup_table_mem_flds {
	CFA_P58_PROF_INPUT_LOOKUP_TABLE_MEM_PARIF_FLD = 0,
	CFA_P58_PROF_INPUT_LOOKUP_TABLE_MEM_EN_BD_META_FLD = 1,
	CFA_P58_PROF_INPUT_LOOKUP_TABLE_MEM_EN_BD_ACTION_FLD = 2,
	CFA_P58_PROF_INPUT_LOOKUP_TABLE_MEM_EN_ILT_DEST_FLD = 3,
	CFA_P58_PROF_INPUT_LOOKUP_TABLE_MEM_FWD_OP_FLD = 4,
	CFA_P58_PROF_INPUT_LOOKUP_TABLE_MEM_ACT_REC_PTR_FLD = 5,
	CFA_P58_PROF_INPUT_LOOKUP_TABLE_MEM_DESTINATION_FLD = 6,
	CFA_P58_PROF_INPUT_LOOKUP_TABLE_MEM_MAX_FLD
};

#define CFA_P58_PROF_INPUT_LOOKUP_TABLE_MEM_TOTAL_NUM_BITS 41

/* Partition. Replaces parif from Input block (for idx 1 ...) */
#define CFA_P58_PROF_L2_CTXT_REMAP_MEM_PARIF_BITPOS 39
#define CFA_P58_PROF_L2_CTXT_REMAP_MEM_PARIF_NUM_BITS 4

/* L2 logical id which may be used in EM and WC Lookups. */
#define CFA_P58_PROF_L2_CTXT_REMAP_MEM_L2_CTXT_BITPOS 29
#define CFA_P58_PROF_L2_CTXT_REMAP_MEM_L2_CTXT_NUM_BITS 10

/* Context operation code. */
#define CFA_P58_PROF_L2_CTXT_REMAP_MEM_CTXT_OPCODE_BITPOS 26
#define CFA_P58_PROF_L2_CTXT_REMAP_MEM_CTXT_OPCODE_NUM_BITS 3
enum cfa_p58_prof_l2_ctxt_remap_mem_ctxt_opcode {
	/* def_ctxt_data provides destination */
	CFA_P58_PROF_L2_CTXT_REMAP_MEM_BYPASS_CFA = 0x0UL,
	/* def_ctxt_data provides act_rec_ptr */
	CFA_P58_PROF_L2_CTXT_REMAP_MEM_BYPASS_LKUP = 0x1UL,
	/* metadata modified with def_ctxt_data */
	CFA_P58_PROF_L2_CTXT_REMAP_MEM_META_UPDATE = 0x2UL,
	/* continue normal flow */
	CFA_P58_PROF_L2_CTXT_REMAP_MEM_NORMAL_FLOW = 0x3UL,
	/* mark packet for drop */
	CFA_P58_PROF_L2_CTXT_REMAP_MEM_DROP = 0x4UL,
	CFA_P58_PROF_L2_CTXT_REMAP_MEM_MAX = 0x7UL
};

/* data dependent on ctxt_opcode. */
#define CFA_P58_PROF_L2_CTXT_REMAP_MEM_DEF_CTXT_DATA_BITPOS 10
#define CFA_P58_PROF_L2_CTXT_REMAP_MEM_DEF_CTXT_DATA_NUM_BITS 16

/* Selects 1 of 8x 16-bit masks for META_UPDATE only. */
#define CFA_P58_PROF_L2_CTXT_REMAP_MEM_CTXT_META_PROF_BITPOS 7
#define CFA_P58_PROF_L2_CTXT_REMAP_MEM_CTXT_META_PROF_NUM_BITS 3

/* Allow Profile TCAM Lookup Table to be logically partitioned. */
#define CFA_P58_PROF_L2_CTXT_REMAP_MEM_PROF_FUNC_BITPOS 0
#define CFA_P58_PROF_L2_CTXT_REMAP_MEM_PROF_FUNC_NUM_BITS 7

enum cfa_p58_prof_l2_ctxt_remap_mem_flds {
	CFA_P58_PROF_L2_CTXT_REMAP_MEM_PARIF_FLD = 0,
	CFA_P58_PROF_L2_CTXT_REMAP_MEM_L2_CTXT_FLD = 1,
	CFA_P58_PROF_L2_CTXT_REMAP_MEM_CTXT_OPCODE_FLD = 2,
	CFA_P58_PROF_L2_CTXT_REMAP_MEM_DEF_CTXT_DATA_FLD = 3,
	CFA_P58_PROF_L2_CTXT_REMAP_MEM_CTXT_META_PROF_FLD = 4,
	CFA_P58_PROF_L2_CTXT_REMAP_MEM_PROF_FUNC_FLD = 5,
	CFA_P58_PROF_L2_CTXT_REMAP_MEM_MAX_FLD
};

#define CFA_P58_PROF_L2_CTXT_REMAP_MEM_TOTAL_NUM_BITS 43

/* Normal operation. (for idx 1 ...) */
#define CFA_P58_PROF_PROFILE_TCAM_REMAP_MEM_PL_BYP_LKUP_EN_BITPOS 32
#define CFA_P58_PROF_PROFILE_TCAM_REMAP_MEM_PL_BYP_LKUP_EN_NUM_BITS 1

/* Enable search in EM database. */
#define CFA_P58_PROF_PROFILE_TCAM_REMAP_MEM_EM_SEARCH_EN_BITPOS 31
#define CFA_P58_PROF_PROFILE_TCAM_REMAP_MEM_EM_SEARCH_EN_NUM_BITS 1

/* ID to differentiate common EM keys. */
#define CFA_P58_PROF_PROFILE_TCAM_REMAP_MEM_EM_PROFILE_ID_BITPOS 23
#define CFA_P58_PROF_PROFILE_TCAM_REMAP_MEM_EM_PROFILE_ID_NUM_BITS 8

/* Exact match key template select. */
#define CFA_P58_PROF_PROFILE_TCAM_REMAP_MEM_EM_KEY_ID_BITPOS 17
#define CFA_P58_PROF_PROFILE_TCAM_REMAP_MEM_EM_KEY_ID_NUM_BITS 6

/* Exact Match key type. Specifies normal/LAG EM lookups. */
#define CFA_P58_PROF_PROFILE_TCAM_REMAP_MEM_EM_KEY_TYPE_BITPOS 15
#define CFA_P58_PROF_PROFILE_TCAM_REMAP_MEM_EM_KEY_TYPE_NUM_BITS 2

/* Enable search in TCAM database. */
#define CFA_P58_PROF_PROFILE_TCAM_REMAP_MEM_TCAM_SEARCH_EN_BITPOS 14
#define CFA_P58_PROF_PROFILE_TCAM_REMAP_MEM_TCAM_SEARCH_EN_NUM_BITS 1

/* ID to differentiate common TCAM keys. */
#define CFA_P58_PROF_PROFILE_TCAM_REMAP_MEM_TCAM_PROFILE_ID_BITPOS 6
#define CFA_P58_PROF_PROFILE_TCAM_REMAP_MEM_TCAM_PROFILE_ID_NUM_BITS 8

/* TCAM key template select. */
#define CFA_P58_PROF_PROFILE_TCAM_REMAP_MEM_TCAM_KEY_ID_BITPOS 0
#define CFA_P58_PROF_PROFILE_TCAM_REMAP_MEM_TCAM_KEY_ID_NUM_BITS 6

/* Bypass operation. (for idx 1 ...) */

/* Reserved for future use. */
#define CFA_P58_PROF_PROFILE_TCAM_REMAP_MEM_RESERVED_BITPOS 18
#define CFA_P58_PROF_PROFILE_TCAM_REMAP_MEM_RESERVED_NUM_BITS 14

/* Bypass operations. */
#define CFA_P58_PROF_PROFILE_TCAM_REMAP_MEM_BYPASS_OP_BITPOS 16
#define CFA_P58_PROF_PROFILE_TCAM_REMAP_MEM_BYPASS_OP_NUM_BITS 2
enum cfa_p58_prof_profile_tcam_remap_mem_bypass_op {
	/* set the drop flag. */
	CFA_P58_PROF_PROFILE_TCAM_REMAP_MEM_DROP = 0x0UL,
	/* Byass lookup use act_record_ptr from this table. */
	CFA_P58_PROF_PROFILE_TCAM_REMAP_MEM_BYPASS_LKUP = 0x1UL,
	/* Byass lookup use Partition Default Action Record Pointer Table */
	CFA_P58_PROF_PROFILE_TCAM_REMAP_MEM_BYPASS_DEFAULT = 0x2UL,
	/* Byass lookup use Partition Error Action Record Pointer Table. */
	CFA_P58_PROF_PROFILE_TCAM_REMAP_MEM_BYPASS_ERROR = 0x3UL,
	CFA_P58_PROF_PROFILE_TCAM_REMAP_MEM_MAX = 0x3UL
};

/* Used for BYPASS_LKUP. */
#define CFA_P58_PROF_PROFILE_TCAM_REMAP_MEM_ACT_RECORD_PTR_BITPOS 0
#define CFA_P58_PROF_PROFILE_TCAM_REMAP_MEM_ACT_RECORD_PTR_NUM_BITS 16

enum cfa_p58_prof_profile_tcam_remap_mem_flds {
	CFA_P58_PROF_PROFILE_TCAM_REMAP_MEM_PL_BYP_LKUP_EN_FLD = 0,
	CFA_P58_PROF_PROFILE_TCAM_REMAP_MEM_EM_SEARCH_EN_FLD = 1,
	CFA_P58_PROF_PROFILE_TCAM_REMAP_MEM_EM_PROFILE_ID_FLD = 2,
	CFA_P58_PROF_PROFILE_TCAM_REMAP_MEM_EM_KEY_ID_FLD = 3,
	CFA_P58_PROF_PROFILE_TCAM_REMAP_MEM_EM_KEY_TYPE_FLD = 4,
	CFA_P58_PROF_PROFILE_TCAM_REMAP_MEM_TCAM_SEARCH_EN_FLD = 5,
	CFA_P58_PROF_PROFILE_TCAM_REMAP_MEM_TCAM_PROFILE_ID_FLD = 6,
	CFA_P58_PROF_PROFILE_TCAM_REMAP_MEM_TCAM_KEY_ID_FLD = 7,
	/* The enumerators below are from the autogenerated
	 * enum cfa_p58_prof_profile_tcam_remap_mem_1_flds which
	 * is deleted
	 */
	CFA_P58_PROF_PROFILE_TCAM_REMAP_MEM_RESERVED_FLD = 8,
	CFA_P58_PROF_PROFILE_TCAM_REMAP_MEM_BYPASS_OP_FLD = 9,
	CFA_P58_PROF_PROFILE_TCAM_REMAP_MEM_ACT_RECORD_PTR_FLD = 10,
	CFA_P58_PROF_PROFILE_TCAM_REMAP_MEM_MAX_FLD
};

#define CFA_P58_PROF_PROFILE_TCAM_REMAP_MEM_TOTAL_NUM_BITS 33

/* Reserved for future use. */
#define CFA_P58_ACT_VSPT_TX_RSVD_BITPOS 40
#define CFA_P58_ACT_VSPT_TX_RSVD_NUM_BITS 41

/* VLAN TPID anti-spoofing control. (for idx 1 ...) */
#define CFA_P58_ACT_VSPT_TPID_AS_CTL_BITPOS 38
#define CFA_P58_ACT_VSPT_TPID_AS_CTL_NUM_BITS 2
enum cfa_p58_act_vspt_tpid_as_ctl {
	CFA_P58_ACT_VSPT_TPID_IGNORE = 0x0UL,
	CFA_P58_ACT_VSPT_TPID_DEFAULT = 0x1UL,
	CFA_P58_ACT_VSPT_TPID_DROP = 0x2UL,
	CFA_P58_ACT_VSPT_TPID_MAX = 0x3UL
};

/* VLAN allowed TPID bit map. */
#define CFA_P58_ACT_VSPT_ALWD_TPID_BITPOS 30
#define CFA_P58_ACT_VSPT_ALWD_TPID_NUM_BITS 8

/* VLAN encoded default TPID. */
#define CFA_P58_ACT_VSPT_DFLT_TPID_BITPOS 27
#define CFA_P58_ACT_VSPT_DFLT_TPID_NUM_BITS 3

/* VLAN PRIority anti-spoofing control. */
#define CFA_P58_ACT_VSPT_PRI_AS_CTL_BITPOS 25
#define CFA_P58_ACT_VSPT_PRI_AS_CTL_NUM_BITS 2
enum cfa_p58_act_vspt_pri_as_ctl {
	CFA_P58_ACT_VSPTPRI_IGNORE = 0x0UL,
	CFA_P58_ACT_VSPTPRI_DEFAULT = 0x1UL,
	CFA_P58_ACT_VSPTPRI_DROP = 0x2UL,
	CFA_P58_ACT_VSPTPRI_MAX = 0x3UL
};

/* VLAN allowed PRIority bit map. */
#define CFA_P58_ACT_VSPT_ALWD_PRI_BITPOS 17
#define CFA_P58_ACT_VSPT_ALWD_PRI_NUM_BITS 8

/* VLAN default PRIority. */
#define CFA_P58_ACT_VSPT_DFLT_PRI_BITPOS 14
#define CFA_P58_ACT_VSPT_DFLT_PRI_NUM_BITS 3

/* Mirror destination (0..15) or 4'bF=NO_MIRROR */
#define CFA_P58_ACT_VSPT_MIR_BITPOS 10
#define CFA_P58_ACT_VSPT_MIR_NUM_BITS 4

/* Pointer to per svif meter; 0x0 = disabled */
#define CFA_P58_ACT_VSPT_IFMTR_BITPOS 0
#define CFA_P58_ACT_VSPT_IFMTR_NUM_BITS 10

enum cfa_p58_act_vspt_flds {
	CFA_P58_ACT_VSPT_TX_RSVD_FLD = 0,
	CFA_P58_ACT_VSPT_TPID_AS_CTL_FLD = 1,
	CFA_P58_ACT_VSPT_ALWD_TPID_FLD = 2,
	CFA_P58_ACT_VSPT_DFLT_TPID_FLD = 3,
	CFA_P58_ACT_VSPT_PRI_AS_CTL_FLD = 4,
	CFA_P58_ACT_VSPT_ALWD_PRI_FLD = 5,
	CFA_P58_ACT_VSPT_DFLT_PRI_FLD = 6,
	CFA_P58_ACT_VSPT_MIR_FLD = 7,
	CFA_P58_ACT_VSPT_IFMTR_FLD = 8,
	CFA_P58_ACT_VSPT_MAX_FLD
};

#define CFA_P58_ACT_VSPT_TOTAL_NUM_BITS 81

/* Enable source knockout. (for idx 2 ...) */
#define CFA_P58_ACT_VSPTABC123_SRC_KO_EN_BITPOS 80
#define CFA_P58_ACT_VSPTABC123_SRC_KO_EN_NUM_BITS 1

/* MAC associated with vnic for sko. */
#define CFA_P58_ACT_VSPTABC123_MAC_BITPOS 32
#define CFA_P58_ACT_VSPTABC123_MAC_NUM_BITS 48

/* Function ID: 4 bit PF and 12 bit VID (VNIC ID) */
#define CFA_P58_ACT_VSPTABC123_FID_BITPOS 16
#define CFA_P58_ACT_VSPTABC123_FID_NUM_BITS 16

/* Reserved for Future use. */
#define CFA_P58_ACT_VSPTABC123_RX_RSVD_BITPOS 14
#define CFA_P58_ACT_VSPTABC123_RX_RSVD_NUM_BITS 2

/* Mirror destination (0..15) or 4'bF=NO_MIRROR */
#define CFA_P58_ACT_VSPTABC123_RX_MIR_BITPOS 10
#define CFA_P58_ACT_VSPTABC123_RX_MIR_NUM_BITS 4

/* Pointer to per vnic meter; 0x0 = disabled */
#define CFA_P58_ACT_VSPTABC123_RX_IFMTR_BITPOS 0
#define CFA_P58_ACT_VSPTABC123_RX_IFMTR_NUM_BITS 10

enum cfa_p58_act_vsptabc123_flds {
	CFA_P58_ACT_VSPTABC123_SRC_KO_EN_FLD = 0,
	CFA_P58_ACT_VSPTABC123_MAC_FLD = 1,
	CFA_P58_ACT_VSPTABC123_FID_FLD = 2,
	CFA_P58_ACT_VSPTABC123_RX_RSVD_FLD = 3,
	CFA_P58_ACT_VSPTABC123_RX_MIR_FLD = 4,
	CFA_P58_ACT_VSPTABC123_RX_IFMTR_FLD = 5,
	CFA_P58_ACT_VSPTABC123_MAX_FLD
};

#define CFA_P58_ACT_VSPTABC123_TOTAL_NUM_BITS 81

/* Destination or metadata. (for idx 1 ...) */
#define CFA_P58_LKUPP5_TCAM_RECORD_MEM_STRENGTH_BITPOS 36
#define CFA_P58_LKUPP5_TCAM_RECORD_MEM_STRENGTH_NUM_BITS 2

/* Destination or metadata. */
#define CFA_P58_LKUPP5_TCAM_RECORD_MEM_DATA_BITPOS 20
#define CFA_P58_LKUPP5_TCAM_RECORD_MEM_DATA_NUM_BITS 16

/* Opcode. */
#define CFA_P58_LKUPP5_TCAM_RECORD_MEM_OPCODE_BITPOS 17
#define CFA_P58_LKUPP5_TCAM_RECORD_MEM_OPCODE_NUM_BITS 3

/* Metadata profile */
#define CFA_P58_LKUPP5_TCAM_RECORD_MEM_META_PROF_BITPOS 14
#define CFA_P58_LKUPP5_TCAM_RECORD_MEM_META_PROF_NUM_BITS 3

/* Connection pointer or ring table index */
#define CFA_P58_LKUPP5_TCAM_RECORD_MEM_CTXT_DATA_BITPOS 0
#define CFA_P58_LKUPP5_TCAM_RECORD_MEM_CTXT_DATA_NUM_BITS 14

enum cfa_p58_lkupp5_tcam_record_mem_flds {
	CFA_P58_LKUPP5_TCAM_RECORD_MEM_STRENGTH_FLD = 0,
	CFA_P58_LKUPP5_TCAM_RECORD_MEM_DATA_FLD = 1,
	CFA_P58_LKUPP5_TCAM_RECORD_MEM_OPCODE_FLD = 2,
	CFA_P58_LKUPP5_TCAM_RECORD_MEM_META_PROF_FLD = 3,
	CFA_P58_LKUPP5_TCAM_RECORD_MEM_CTXT_DATA_FLD = 4,
	CFA_P58_LKUPP5_TCAM_RECORD_MEM_MAX_FLD
};

#define CFA_P58_LKUPP5_TCAM_RECORD_MEM_TOTAL_NUM_BITS 38

/* If 0 (invalid), connection tracking and filtering is disabled
 * for the connection and the output action[1:0] is set to forward
 * and copy_enabled=0
 */
#define CFA_P58_LKUP_CNX_MEM_VALID_BITPOS 10
#define CFA_P58_LKUP_CNX_MEM_VALID_NUM_BITS 1

/* Enable the copy action[1:0]. If not enabled for a connection and the output
 * result action[1:0] is copy, it is overridden and set to forward.
 */
#define CFA_P58_LKUP_CNX_MEM_COPY_ENABLED_BITPOS 9
#define CFA_P58_LKUP_CNX_MEM_COPY_ENABLED_NUM_BITS 1

/* Set to 1 if shared=1 and send_state=1 in matching rule and interface flow
 * controlled. Will get send on next operation to entry in which the message
 * interface to the other CFA is not flow controlled. Sent immediately on host
 * write of 1 if not flow controlled (intended for debug).
 */
#define CFA_P58_LKUP_CNX_MEM_SEND_PENDING_BITPOS 8
#define CFA_P58_LKUP_CNX_MEM_SEND_PENDING_NUM_BITS 1

/* If 1, enables notifications of the other CFA for this connection. These
 * notifications are sent if a matching state machine rule specifies the
 * notification as one of its actions.
 */
#define CFA_P58_LKUP_CNX_MEM_SHARED_BITPOS 7
#define CFA_P58_LKUP_CNX_MEM_SHARED_NUM_BITS 1

/* Current state for connection. */
#define CFA_P58_LKUP_CNX_MEM_STATE_BITPOS 4
#define CFA_P58_LKUP_CNX_MEM_STATE_NUM_BITS 3

/* Current timer value for connection. */
#define CFA_P58_LKUP_CNX_MEM_TIMER_VALUE_BITPOS 0
#define CFA_P58_LKUP_CNX_MEM_TIMER_VALUE_NUM_BITS 4

enum cfa_p58_lkup_cnx_mem_flds {
	CFA_P58_LKUP_CNX_MEM_VALID_FLD = 0,
	CFA_P58_LKUP_CNX_MEM_COPY_ENABLED_FLD = 1,
	CFA_P58_LKUP_CNX_MEM_SEND_PENDING_FLD = 2,
	CFA_P58_LKUP_CNX_MEM_SHARED_FLD = 3,
	CFA_P58_LKUP_CNX_MEM_STATE_FLD = 4,
	CFA_P58_LKUP_CNX_MEM_TIMER_VALUE_FLD = 5,
	CFA_P58_LKUP_CNX_MEM_MAX_FLD
};

#define CFA_P58_LKUP_CNX_MEM_TOTAL_NUM_BITS 11

/* Entry is valid. (for idx 3 ...) */
#define CFA_P58_LKUPP5_EM_RECORD_MEM_VALID_BITPOS 99
#define CFA_P58_LKUPP5_EM_RECORD_MEM_VALID_NUM_BITS 1

/* For resolving TCAM/EM conflicts (for idx 3 ...) */
#define CFA_P58_LKUPP5_EM_RECORD_MEM_STRENGTH_BITPOS 97
#define CFA_P58_LKUPP5_EM_RECORD_MEM_STRENGTH_NUM_BITS 2

/* Destination or metadata. */
#define CFA_P58_LKUPP5_EM_RECORD_MEM_DATA_BITPOS 81
#define CFA_P58_LKUPP5_EM_RECORD_MEM_DATA_NUM_BITS 16

/* Opcode. (for idx 2 ...) */
#define CFA_P58_LKUPP5_EM_RECORD_MEM_OPCODE_BITPOS 78
#define CFA_P58_LKUPP5_EM_RECORD_MEM_OPCODE_NUM_BITS 3

/* Metadata profile. (for idx 2 ...) */
#define CFA_P58_LKUPP5_EM_RECORD_MEM_META_PROF_BITPOS 75
#define CFA_P58_LKUPP5_EM_RECORD_MEM_META_PROF_NUM_BITS 3

/* Connection pointer or ring table index. */
#define CFA_P58_LKUPP5_EM_RECORD_MEM_CTXT_DATA_BITPOS 61
#define CFA_P58_LKUPP5_EM_RECORD_MEM_CTXT_DATA_NUM_BITS 14

/* Key and spare bits. Next Block Entry (nblock) */
#define CFA_P58_LKUPP5_EM_RECORD_MEM_FIRST_KEY_DATA_BITPOS 0
#define CFA_P58_LKUPP5_EM_RECORD_MEM_FIRST_KEY_DATA_NUM_BITS 61

/* Key and spare bits. None-auto-generated. */
#define CFA_P58_LKUPP5_EM_RECORD_MEM_SECOND_KEY_DATA_LOW_BITPOS 128
#define CFA_P58_LKUPP5_EM_RECORD_MEM_SECOND_KEY_DATA_LOW_NUM_BITS 64

#define CFA_P58_LKUPP5_EM_RECORD_MEM_SECOND_KEY_DATA_HIGH_BITPOS 192
#define CFA_P58_LKUPP5_EM_RECORD_MEM_SECOND_KEY_DATA_HIGH_NUM_BITS 64

#define CFA_P58_LKUPP5_EM_RECORD_MEM_THIRD_KEY_DATA_LOW_BITPOS 256
#define CFA_P58_LKUPP5_EM_RECORD_MEM_THIRD_KEY_DATA_LOW_NUM_BITS 64

#define CFA_P58_LKUPP5_EM_RECORD_MEM_THIRD_KEY_DATA_HIGH_BITPOS 320
#define CFA_P58_LKUPP5_EM_RECORD_MEM_THIRD_KEY_DATA_HIGH_NUM_BITS 64

#define CFA_P58_LKUPP5_EM_RECORD_MEM_FOURTH_KEY_DATA_LOW_BITPOS 384
#define CFA_P58_LKUPP5_EM_RECORD_MEM_FOURTH_KEY_DATA_LOW_NUM_BITS 64

#define CFA_P58_LKUPP5_EM_RECORD_MEM_FOURTH_KEY_DATA_HIGH_BITPOS 448
#define CFA_P58_LKUPP5_EM_RECORD_MEM_FOURTH_KEY_DATA_HIGH_NUM_BITS 64

/* None-auto-generated. */
enum cfa_p58_lkupp5_em_record_mem_flds {
	CFA_P58_LKUPP5_EM_RECORD_MEM_VALID_FLD = 0,
	CFA_P58_LKUPP5_EM_RECORD_MEM_STRENGTH_FLD = 1,
	CFA_P58_LKUPP5_EM_RECORD_MEM_DATA_FLD = 2,
	CFA_P58_LKUPP5_EM_RECORD_MEM_OPCODE_FLD = 3,
	CFA_P58_LKUPP5_EM_RECORD_MEM_META_PROF_FLD = 4,
	CFA_P58_LKUPP5_EM_RECORD_MEM_CTXT_DATA_FLD = 5,
	CFA_P58_LKUPP5_EM_RECORD_MEM_FIRST_KEY_DATA_FLD = 6,
	CFA_P58_LKUPP5_EM_RECORD_MEM_SECORD_KEY_DATA_LOW_FLD = 7,
	CFA_P58_LKUPP5_EM_RECORD_MEM_SECORD_KEY_DATA_HIGH_FLD = 8,
	CFA_P58_LKUPP5_EM_RECORD_MEM_THIRD_KEY_DATA_LOW_FLD = 9,
	CFA_P58_LKUPP5_EM_RECORD_MEM_THIRD_KEY_DATA_HIGH_FLD = 10,
	CFA_P58_LKUPP5_EM_RECORD_MEM_FOURTH_KEY_DATA_LOW_FLD = 11,
	CFA_P58_LKUPP5_EM_RECORD_MEM_FOURTH_KEY_DATA_HIGH_FLD = 12,
	CFA_P58_LKUPP5_EM_RECORD_MEM_MAX_FLD
};

/* Auto-generated number is modified. */
#define CFA_P58_LKUPP5_EM_RECORD_MEM_TOTAL_NUM_BITS 512

/* Excess Information Rate. */
#define CFA_P58_ACT_P5_MPT_EIR_BITPOS 48
#define CFA_P58_ACT_P5_MPT_EIR_NUM_BITS 17

/* Committed Information Rate. */
#define CFA_P58_ACT_P5_MPT_CIR_BITPOS 31
#define CFA_P58_ACT_P5_MPT_CIR_NUM_BITS 17

/* Excess Burst Size. */
#define CFA_P58_ACT_P5_MPT_EBS_BITPOS 19
#define CFA_P58_ACT_P5_MPT_EBS_NUM_BITS 12

/* Committed Burst Size. */
#define CFA_P58_ACT_P5_MPT_CBS_BITPOS 7
#define CFA_P58_ACT_P5_MPT_CBS_NUM_BITS 12

/* Excess Bucket No Decrement. */
#define CFA_P58_ACT_P5_MPT_EBND_BITPOS 6
#define CFA_P58_ACT_P5_MPT_EBND_NUM_BITS 1

/* Committed Bucket No Decrement. */
#define CFA_P58_ACT_P5_MPT_CBND_BITPOS 5
#define CFA_P58_ACT_P5_MPT_CBND_NUM_BITS 1

/* Excess Bucket Strict Mode. */
#define CFA_P58_ACT_P5_MPT_EBSM_BITPOS 4
#define CFA_P58_ACT_P5_MPT_EBSM_NUM_BITS 1

/* Committed Bucket Strict Mode. */
#define CFA_P58_ACT_P5_MPT_CBSM_BITPOS 3
#define CFA_P58_ACT_P5_MPT_CBSM_NUM_BITS 1

/* RFC2698 Mode. */
#define CFA_P58_ACT_P5_MPT_RFC2698_BITPOS 2
#define CFA_P58_ACT_P5_MPT_RFC2698_NUM_BITS 1

/* Packet Mode. */
#define CFA_P58_ACT_P5_MPT_PM_BITPOS 1
#define CFA_P58_ACT_P5_MPT_PM_NUM_BITS 1

/* Coupling Flag. */
#define CFA_P58_ACT_P5_MPT_CF_BITPOS 0
#define CFA_P58_ACT_P5_MPT_CF_NUM_BITS 1

enum cfa_p58_act_p5_mpt_flds {
	CFA_P58_ACT_P5_MPT_EIR_FLD = 0,
	CFA_P58_ACT_P5_MPT_CIR_FLD = 1,
	CFA_P58_ACT_P5_MPT_EBS_FLD = 2,
	CFA_P58_ACT_P5_MPT_CBS_FLD = 3,
	CFA_P58_ACT_P5_MPT_EBND_FLD = 4,
	CFA_P58_ACT_P5_MPT_CBND_FLD = 5,
	CFA_P58_ACT_P5_MPT_EBSM_FLD = 6,
	CFA_P58_ACT_P5_MPT_CBSM_FLD = 7,
	CFA_P58_ACT_P5_MPT_RFC2698_FLD = 8,
	CFA_P58_ACT_P5_MPT_PM_FLD = 9,
	CFA_P58_ACT_P5_MPT_CF_FLD = 10,
	CFA_P58_ACT_P5_MPT_MAX_FLD
};

#define CFA_P58_ACT_P5_MPT_TOTAL_NUM_BITS 65

/* CFA flexible key layout definition */
enum cfa_p58_key_fld_id { CFA_P58_KEY_FLD_ID_MAX };

/* Mirror - Non-autogenerated */
#define CFA_P58_ACTP5_MICR_EN_BITPOS 31
#define CFA_P58_ACTP5_MICR_EN_NUM_BITS 1

#define CFA_P58_ACTP5_MICR_COPY_BITPOS 30
#define CFA_P58_ACTP5_MICR_COPY_NUM_BITS 1

#define CFA_P58_ACTP5_MICR_IGN_DROP_BITPOS 29
#define CFA_P58_ACTP5_MICR_IGN_DROP_NUM_BITS 1

#define CFA_P58_ACTP5_MICR_AR_PTR_BITPOS 0
#define CFA_P58_ACTP5_MICR_AR_PTR_NUM_BITS 16

enum cfa_p58_mirror_flds {
	CFA_P58_MIRROR_TBL_EN_FLD,
	CFA_P58_MIRROR_TBL_COPY_FLD,
	CFA_P58_MIRROR_TBL_IGN_DROP_FLD,
	CFA_P58_MIRROR_TBL_AR_PTR_FLD,
	CFA_P58_MIRROR_TBL_MAX_FLD
};

#define CFA_P58_ACTP5_MICR_TOTAL_NUM_BITS 32

/* ABCR- Non-autogenerated */
#define CFA_P58_ACT_ABCR_VTAG_TPID_BITPOS 16
#define CFA_P58_ACT_ABCR_VTAG_TPID_NUM_BITS 16

#define CFA_P58_ACT_ABCR_DFLTPRI_BITPOS 13
#define CFA_P58_ACT_ABCR_DFLTPRI_NUM_BITS 3

#define CFA_P58_ACT_ABCR_ECNM_EN_BITPOS 12
#define CFA_P58_ACT_ABCR_ECNM_EN_NUM_BITS 1

#define CFA_P58_ACT_ABCR_ECNP_EN_BITPOS 10
#define CFA_P58_ACT_ABCR_ECNP_EN_NUM_BITS 1

#define CFA_P58_ACT_ABCR_VEB_EN_BITPOS 9
#define CFA_P58_ACT_ABCR_VEB_EN_NUM_BITS 1

#define CFA_P58_ACT_ABCR_TX_HW_HDR_BITPOS 7
#define CFA_P58_ACT_ABCR_TX_HW_HDR_NUM_BITS 2

#define CFA_P58_ACT_ABCR_VTAG_EDIT_EN_BITPOS 4
#define CFA_P58_ACT_ABCR_VTAG_EDIT_EN_NUM_BITS 1

#define CFA_P58_ACT_ABCR_MCAST_EN_BITPOS 3
#define CFA_P58_ACT_ABCR_MCAST_EN_NUM_BITS 1

#define CFA_P58_ACT_ABCR_QCN_DLT_EN_BITPOS 1
#define CFA_P58_ACT_ABCR_QCN_DLT_EN_NUM_BITS 1

enum cfa_p58_abcr_flds {
	CFA_P58_ACT_ABCR_TBL_VTAG_TPID_FLD,
	CFA_P58_ACT_ABCR_TBL_DFLTPRI_FLD,
	CFA_P58_ACT_ABCR_TBL_ECNM_EN_FLD,
	CFA_P58_ACT_ABCR_TBL_ECNP_EN_FLD,
	CFA_P58_ACT_ABCR_TBL_VEB_EN_FLD,
	CFA_P58_ACT_ABCR_TBL_TX_HW_HDR_FLD,
	CFA_P58_ACT_ABCR_TBL_VTAG_EDIT_EN_FLD,
	CFA_P58_ACT_ABCR_TBL_MCAST_EN_FLD,
	CFA_P58_ACT_ABCR_TBL_QCN_DLT_EN_FLD,
	CFA_P58_ACT_ABCR_TBL_MAX_FLD
};

#define CFA_P58_ACT_ABCR_TOTAL_NUM_BITS 32

#endif /* _CFA_P58_HW_H_ */
