#!/usr/bin/bash

# Update depmod after removing driver
if [ -f /boot/System.map-$(uname -r) ]; then
	depmod -a "$(uname -r)" -F "/boot/System.map-$(uname -r)"
else
	depmod -a "$(uname -r)"
fi  

# Remove "megaraid_sas" entry from /etc/initramfs-tools/modules.
if grep -q "megaraid_sas" "/etc/initramfs-tools/modules"; then
	sed -i '/megaraid_sas/d' "/etc/initramfs-tools/modules"
fi

# Back up the current initrd
echo "Backing up initrd.img-$(uname -r)" "initrd.img-$(uname -r).old-dkms"
cp -f "/boot/initrd.img-$(uname -r)" "/boot/initrd.img-$(uname -r).old-dkms"

# Update initrd
update-initramfs -u -k "$(uname -r)"

